﻿filterAnalytics.ResponsesFilter = null;
$(document).ready(function () {

    dashboardFilter.context = $(".filter-configuration");
    dashboardFilter.initializeAutoCompletes();
    dashboardFilter.bindFilterHeaderEvents();
    // Initialize the Survey Data Filter
    a4logicEditor.initializeEditors($(".filter-responses", dashboardFilter.context), [], true);
    applyAutoCompleteForSurveyDataFilter();
});

var filterSettings = {};
var lastFromDate = "";
var lastToDate = "";
var dashboardFilter = {
    context: null,
    filterLoaded: false,
    tooltipStyle: "width:auto; min-width:100px; padding:5px; border-radius: 2px;",
    tooltipPosition: { "my": "right", "at": "left" },
    initializeAutoCompletes: function () {
        $(".dashboard-filters-autocomplete", dashboardFilter.context).a4autocomplete({
            ajaxAction: a4.getAction("GetDashboardCustomFilters", "AdvancedAnalytics", "Survey"),
            select: function (event, data) {
            },
            tooltipProperty: "Value",
            tooltipData: "Label",
            tooltipCustomStyle: dashboardFilter.tooltipStyle,
            tooltipCustomPosition: dashboardFilter.tooltipPosition
        });

        initializeDateFormat();
    },
    bindFilterHeaderEvents: function (saveFunction) {
        // Save custom filter
        dashboardFilter.context.on("click", ".save-dashboard-filter", function () {
            filterAnalytics.Id = $("#hdnFilterId").val();
            filterAnalytics.SentimentType = $('.filter-sentimentType :selected').val();
            filterAnalytics.FromDate = $('.filter-fromDate').val();
            filterAnalytics.ToDate = $('.filter-toDate').val();
            filterAnalytics.FilterAction = "";

            // Get Survey Data filter
            let responsesFilter = a4logicEditor.getLogic($(".filter-responses .v-logicEditor"), true);
            filterAnalytics.ResponsesFilter = responsesFilter;
            filterAnalytics.ResponseFilterJSON = JSON.stringify(responsesFilter);

            if (!activitySectionValidation(filterAnalytics, responsesFilter)) {
                return false;
            }

            dashboardFilter.showSaveDashboardFilterDialog(function (dashboardFilterName) {
                filterAnalytics.CustomFilterName = dashboardFilterName;
                filterAnalytics.CustomFilterId = $(".dashboard-filters-autocomplete").attr("data-value");
                if (filterAnalytics.SentimentType === "All") {
                    filterAnalytics.SentimentType = "";
                }
                if (filterAnalytics.CustomFilterName == "") {
                    a4.showErrorMessage(filterErrorsResources.EnterFilterName);
                    return false;
                } else {
                    a4.callServerMethod(a4.getSurveyAction("AddDashboardCustomFilter", "AdvancedAnalytics"), {
                        "variableId": selectedVariableId,
                        "filterAnalytics": filterAnalytics
                    }, function (response) {
                        if (response == 1) {
                            a4.showSuccessMessage(filterErrorsResources.FilterNameCreatedSuccessfully);
                            $(".dashboard-filters-autocomplete", dashboardFilter.context).a4autocomplete("clearCache");
                        }
                        else if (response == 2) {
                            a4.showSuccessMessage(filterErrorsResources.FilterNameUpdatedSuccessfully);
                        }
                        else if (response == 3) {
                            a4.showErrorMessage(filterErrorsResources.FilterAlreadyExists);
                            return false;
                        }
                        else {
                            a4.showErrorMessage(filterErrorsResources.SomethingWentWrong);
                            return false;
                        }

                        dashboardResults.selectedTopic = "";
                        dashboardsFiltersResponse();
                        modalDialog.close();
                        $(".delete-dashboard-filter").prop("disabled", true);
                    });
                }
            });
        });

        // Delete custom filter
        dashboardFilter.context.on("click", ".delete-dashboard-filter", function () {
            var selectedCustomFilter = $(".dashboard-filters-autocomplete").val();

            if (selectedCustomFilter == "" || selectedCustomFilter == undefined || selectedCustomFilter == null) {
                a4.showErrorMessage(filterErrorsResources.NoFilterSelected);
                $(".delete-dashboard-filter").prop("disabled", true);
            } else {
                selectedCustomFilter = selectedCustomFilter.replace(selectedCustomFilter, '<b>$&</b>');
                confirmDeleteDashboardFilterResources.Message = confirmDeleteDashboardFilterResources.MessageFirstHalf + " " + selectedCustomFilter + ". " + confirmDeleteDashboardFilterResources.MessageSecondHalf;
                modalDialog.showConfirmDialog(confirmDeleteDashboardFilterResources, function () {
                    filterAnalytics.FilterAction = "RemoveCustomFilter";
                    filterAnalytics.CustomFilterId = $(".dashboard-filters-autocomplete").attr("data-value");
                    dashboardResults.selectedTopic = "";
                    dashboardsFiltersResponse();
                    $(".dashboard-filters-autocomplete", dashboardFilter.context).a4autocomplete("clearCache");
                    a4.showSuccessMessage(filterErrorsResources.FilterNameDeletedSuccessfully);
                    $(".delete-dashboard-filter").prop("disabled", true);
                    filterAnalytics.FilterAction = "";
                }, 250, 500, true, {});
            }
        });

        // Change custom filter
        dashboardFilter.context.on("change", ".dashboard-filters-autocomplete", function () {
            var customFilterId = $(".dashboard-filters-autocomplete").attr("data-value");
            if (customFilterId == 'undefined' || customFilterId == '' || customFilterId == null) {
                customFilterId = 0;
                $(".delete-dashboard-filter").attr("disabled", true);
            }
            else {
                $(".delete-dashboard-filter").attr("disabled", false);
            }

            a4.callServerMethod(a4.getSurveyAction("GetCustomFilterSetting", "AdvancedAnalytics"), { "customFilterId": customFilterId }, function (filterData) {
                if (filterData !== null) {
                    filterAnalytics.CustomFilterId = filterData.customFilterId;
                    filterAnalytics.SentimentType = filterData.SentimentType;
                    filterAnalytics.FromDate = filterData.FormattedFromDate;
                    filterAnalytics.ToDate = filterData.FormattedToDate;
                    lastFromDate = filterData.FormattedFromDate;
                    lastToDate = filterData.FormattedToDate;

                    if (filterAnalytics.SentimentType == "") {
                        $('.filter-sentimentType').val("All");
                    } else {
                        filterAnalytics.SentimentType !== null ? $('.filter-sentimentType').val(filterAnalytics.SentimentType) : $('.filter-sentimentType').val("All");
                    }

                    bindFilterSettings(dashboardFilter.context, filterData);

                    if (filterData.FilterSettings) {

                        // Get the partial view for the filter section "Survey Data" based on the selected filter from the dropdown
                        a4.callServerMethod(a4.getSurveyAction("GetSurveyDataFilterView", "AdvancedAnalytics"), { "customFilterId": customFilterId}, function (surveyDataFilterHtml) {
                            $('#dashboardSurveyDataFilter').html(surveyDataFilterHtml);
                            applyAutoCompleteForSurveyDataFilter();
                        });
                    }
                }
                else {
                    a4.showErrorMessage(filterErrorsResources.SomethingWentWrong);
                    return false;
                }
            });
        });
    },

    // Display save filter dialog
    showSaveDashboardFilterDialog: function (saveFunction) {
        var dashboardFilterName = $(".dashboard-filters-autocomplete").val();
        var modernEditor = $('<div class="modernEditor compact" />');

        var editorHeader = $('<div class="header" />');
        editorHeader.append($('<div class=\"title\">').html(dashboardFilterLocalizableTexts.SaveFilterTitle));
        modernEditor.append(editorHeader);

        var editorContent = $('<div class="content" style="padding: 20px !important;" />');
        editorContent.append($('<div class=\"section\" />')
            .append($('<div class="title" />').html(localizableTexts.Name))
            .append($('<div class="field" style="margin-left: -80px;">')
                .append($('<input type=\"text\" class=\"dashboardFilterName saveFilter-input\" />').val(dashboardFilterName))
                .append($('</div>'))));
        modernEditor.append(editorContent);

        var editorFooter = $('<div class="footer" />')
            .append($('<button class=\"button primary\" />').html(localizableTexts.Save).on("click", function () {
                saveFunction($(".dashboardFilterName", modernEditor).val());
            }))
            .append($('<button class=\"link-button mt-4\" />').html(localizableTexts.Cancel).on("click", function () {
                modalDialog.close();
            }))
        modernEditor.append(editorFooter);

        $.fancybox({
            type: 'html',
            content: modernEditor,
            padding: 0,
            autoSize: false,
            width: 380,
            height: 200,
            autoSize: false,
            afterShow: function () {
                $('.modernEditor').find(':input:visible:enabled:first').trigger("focus");
            }
        });
    },
    resetLastActivitySection: function (context) {
        $('.last-activity-section input[type="radio"]', context).prop('checked', false);
        $(".last-activity-section input[type=text]", context).val('');
        filterAnalytics.FilterSettings = {};
        filterSettings = {};
    },
};

function initializeDateFormat() {
    $("input.dateTime").datetimepicker({
        dateFormat: "yy-mm-dd",
        timeFormat: "h:mm TT",
        ampm: true,
        beforeShow: function (input, inst) {
            $(inst.dpDiv).removeAttr('data-utcoffset');
        }
    });
}

function getFilterData(filterData, emptySurveyData = false, setDates = false) {
    if (filterData !== null) {
        filterAnalytics.Id = filterData.Id;
        filterAnalytics.CustomFilterId = filterData.CustomFilterId;
        filterAnalytics.CustomFilterName = filterData.CustomFilterName;
        filterAnalytics.CustomFilterId > 0 ? $(".delete-dashboard-filter").prop("disabled", false) : $(".delete-dashboard-filter").prop("disabled", true);
        filterAnalytics.Id > 0 ? $(".filterIconDiv").css("background", "#43B17B") : $(".filterIconDiv").css("background", "#3D8AB5");
        filterAnalytics.Id > 0 ? $("#hdnFilterId").val(filterData.Id) : $("#hdnFilterId").val(0);
        filterAnalytics.SentimentType = filterData.SentimentType;
        if (!setDates) {
            filterAnalytics.FromDate = filterData.FromDate;
            filterAnalytics.ToDate = filterData.ToDate;
        }
        if (filterAnalytics.SentimentType == "") {
            $('.filter-sentimentType').val("All");
        } else {
            filterAnalytics.SentimentType !== null ? $('.filter-sentimentType').val(filterAnalytics.SentimentType) : $('.filter-sentimentType').val("All");
        }

        if (!setDates) {
            bindFilterSettings(dashboardFilter.context, filterData);
        }

        filterAnalytics.CustomFilterId !== 0 ? $(".dashboard-filters-autocomplete").attr("data-value", filterData.CustomFilterId) : $(".dashboard-filters-autocomplete").attr("data-value", '');
        filterAnalytics.CustomFilterName !== null ? $('.dashboard-filters-autocomplete').val(filterData.CustomFilterName) : $('.dashboard-filters-autocomplete').val('');

        if (filterData.FilterSettings) {
            // Get the partial view for the filter section "Survey Data" based on the selected filter from the dropdown
            a4.callServerMethod(a4.getSurveyAction("GetSurveyDataFilterView", "AdvancedAnalytics"), { "customFilterId": filterAnalytics.CustomFilterId, responsesFilterJson: filterData.ResponseFilterJSON}, function (surveyDataFilterHtml) {
                $('#dashboardSurveyDataFilter').html(surveyDataFilterHtml);
                applyAutoCompleteForSurveyDataFilter();
            });
        }

        if (filterData.FilterAction != "ApplyFilter") {
            lastFromDate = filterAnalytics.FromDate;
            lastToDate = filterAnalytics.ToDate;
        }
        if (emptySurveyData) {
            clearResponseFilter();
        } else {
            filterAnalytics.ResponseFilterJSON = filterData.ResponseFilterJSON;
            filterAnalytics.ResponsesFilter = filterData.ResponsesFilterDTO != undefined ? filterData.ResponsesFilterDTO : null;
        }
    }
}

function applyDashboardFilters() {
    var fromDate = $('.filter-fromDate').val();
    var toDate = $('.filter-toDate').val();
    filterAnalytics.Id = $("#hdnFilterId").val();
    filterAnalytics.SentimentType = $('.filter-sentimentType :selected').val();
    filterAnalytics.FromDate = fromDate;
    filterAnalytics.ToDate = toDate;
    filterAnalytics.FilterAction = "ApplyFilter";
    filterAnalytics.CustomFilterName = $(".dashboard-filters-autocomplete").val();
    filterAnalytics.CustomFilterId = $(".dashboard-filters-autocomplete").attr("data-value");
    if (!filterAnalytics.CustomFilterId) {
        filterAnalytics.CustomFilterId = 0;
    }

    // set activity check box value
    var isTodayChecked = $("#filterDateToday").is(':checked');
    var isMonthChecked = $("#filterDateThisMonth").is(':checked');
    if (isTodayChecked) {
        filterSettings.IsSelectionToday = true;
        filterSettings.IsSelectionThisMonth = false;
    } else if (isMonthChecked) {
        filterSettings.IsSelectionToday = false;
        filterSettings.IsSelectionThisMonth = true;
    } else {
        filterSettings.IsSelectionToday = false;
        filterSettings.IsSelectionThisMonth = false;
    }
    filterAnalytics.FilterSettings = filterSettings;

    // Get Survey Data filter
    let responsesFilter = a4logicEditor.getLogic($(".filter-responses .v-logicEditor"), true);
    filterAnalytics.ResponsesFilter = responsesFilter;
    filterAnalytics.ResponseFilterJSON = JSON.stringify(responsesFilter);

    if (!activitySectionValidation(filterAnalytics, responsesFilter)) {
        return false;
    }

    if (filterAnalytics.SentimentType === "All") {
        filterAnalytics.SentimentType = "";
    }
    dashboardResults.selectedTopic = "";
    dashboardsFiltersResponse();
    filterAnalytics.FilterAction = "";
    _paq.push(['trackEvent', 'Survey-AdvancedAnalytics-TextAnalysis', 'Dashboard:Apply Filter']);
}

function dashboardsFiltersResponse() {
    var trendChartFrequencyOption = $(".sentiment-trendChart-frequency", $(".sentiment-trendChart")).val();

    a4.callServerMethod(a4.getSurveyAction("GetSentimentAnalysisGridResults", "AdvancedAnalytics"), {
        variableId: selectedVariableId,
        "questionName": selectedQuestionName,
        "topicName": dashboardResults.selectedTopic,
        "filterAnalytics": filterAnalytics,
        "trendChartFrequencyOption": trendChartFrequencyOption
    }, function (response) {
        hideLoader();
        getFilterData(response['FilterAnalytics'], false, true);
        if (response.Sentiment.length == 0) {
            showInitialInstructions();
            a4.showErrorMessage(filterErrorsResources.FilterHasNoResponses);
            return;
        }
        else {
            renderPieChart(response['Sentiment']);
            generateCloud(response['Text'], response['WordCloudConfig']);
            showDashboard();

            if (selectedQuestionHasTopicsEnabled) {
                generateTopicTable(response['Topics']);
            }

            dashboardResults.sentiments = null;
            dashboardResults.sentiments = response['Sentiment'];
            openEndAnswer(selectedVariableId);
            renderSentimentTrendChart(response['SentimentTrendData'], response['ColorScheme'], filterAnalytics.SentimentType, trendChartFrequencyOption);
        }
    }, function (error) {
        hideLoader();
    });
}

function clearDashboardFilters() {
    $("#hdnFilterId").val(0);
    $('.filter-sentimentType').val("All");
    filterAnalytics.SentimentType = "";
    filterAnalytics.FromDate = "";
    filterAnalytics.ToDate = "";
    filterAnalytics.FilterAction = "RemoveFilterConfiguration";
    $(".dashboard-filters-autocomplete").val('');
    $(".delete-dashboard-filter").prop("disabled", true);
    $("#onDemandUpdate").show();

    isUpdateAvailable(selectedQuestionName, selectedVariableId);
    dashboardsFiltersResponse();
    dashboardResults.selectedTopic = "";
    filterAnalytics.FilterAction = "";
    lastFromDate = "";
    lastToDate = "";
    clearResponseFilter();
    dashboardFilter.resetLastActivitySection(dashboardFilter.context);
}

function clearResponseFilter() {
    filterAnalytics.ResponseFilterJSON = "";
    filterAnalytics.ResponsesFilter = null;
    $(".v-filterType", filterAnalytics.ResponsesFilter).hide();
    $(".v-custom", filterAnalytics.ResponsesFilter).hide();
    $(".v-custom input", filterAnalytics.ResponsesFilter).val("");
    $(".v-logicTable", filterAnalytics.ResponsesFilter).hide();
    $(".v-customFilterBlock", filterAnalytics.ResponsesFilter).hide();
    $(".v-logicCondition").prop("selectedIndex", 0);
    $(".v-logicTable .v-logicBody tr", filterAnalytics.ResponsesFilter).remove();
}

$('.last-activity-section input[type=text]').on("change", function () {
    if ($(this).val()) {
        var section = $(this).closest('.last-activity-section');
        $("input[type=radio]", section).prop('checked', false);
        filterSettings.IsSelectionToday = false;
        filterSettings.IsSelectionThisMonth = false;
    }
    filterAnalytics.FilterSettings = filterSettings;
});

$('.v-optionLastActivityType input[type="radio"]').on("change", function () {
    var section = $(this).closest('.last-activity-section');
    $('input:radio', section).not('#' + $(this).attr('id')).prop('checked', false);
    $("input[type=text]", section).val('')

    if ($(this).val() == "Today") {
        filterSettings.IsSelectionToday = true;
        filterSettings.IsSelectionThisMonth = false;
    }
    else {
        filterSettings.IsSelectionThisMonth = true;
        filterSettings.IsSelectionToday = false;
    }

    filterAnalytics.FilterSettings = filterSettings;
});

function bindFilter() {
    $(".button", $(".h-statusSelector", filterAnalytics.ResponsesFilter)).on("click", function () {
        var $b = $(this);
        $(".button").removeClass("selected");
        $b.addClass("selected");
        var selectedVal = $b.attr("data-value");
        $("input[type=hidden]", $b.parents(".h-statusSelector")).val(selectedVal);
        $(".v-custom", filterAnalytics.ResponsesFilter).toggle(selectedVal == "Custom");
    });
}

$(document).on("click", ".h-deleteRow", function (e) {
    var item = $(this).closest(".v-questionEditableItem");
    a4logicEditor.replaceItemIndexes(item);
});

$(document).on("change", ".v-logicOperator", function (e) {
    var dgridElement = this.parentElement.parentElement;
    var logicValue = (dgridElement.getElementsByClassName("logic-value-wrapper"))[0];
    if (e.target.value === "Empty" || e.target.value === "NotEmpty") {
        if (!(logicValue.classList.contains("dis-n"))) {
            logicValue.classList.add("dis-n");
        }
    } else if (logicValue.classList.contains("dis-n")) {
        logicValue.classList.remove("dis-n");
    }
});

$('.toggleSurveyData').on("click", function () {
    $(".filter-responses").toggle();
    $('.toggleSurveyData').toggleClass("fa-caret-down fa-caret-right");
});

function applyAutoCompleteForSurveyDataFilter() {
    
    a4logicEditor.setVariableAutoCompleteByAjax($(".filter-responses .v-logicEditor", dashboardFilter.context));

    // Disable the link 'Advanced'
    $('.v-advanceLink', dashboardFilter.context).remove();
}
